% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{SpeedOfSoundSeaWaterDelGrosso}
\alias{SpeedOfSoundSeaWaterDelGrosso}
\title{speed of sound (m/s) in sea water from Del Grosso 1974}
\source{
V.A. Del Grosso, 1974
Underwater Acoustics Technical Guides - Speed of Sound in Sea Water
\url{http://resource.npl.co.uk/acoustics/techguides/soundseawater/}
}
\usage{
SpeedOfSoundSeaWaterDelGrosso(S, temperatureC, P)
}
\arguments{
\item{S,}{salinity in parts per thousand}

\item{temperatureC,}{temperature in degrees Celsius}

\item{P,}{pressure in kg/cm^2}
}
\value{
the speed of sound (m/s)
}
\description{
Returns the speed of sound (m/s)
 Range of validity: temperature 0 to 30 C, salinity 30 to 40 parts per thousand
 pressure 0 to 1000 kg/cm^2 , where 100 kPa=1.019716 kg/cm^2
}
\examples{
SpeedOfSoundSeaWaterDelGrosso(30, 0, 1.019716)
}
\author{
Jose Gama
}
\references{
V.A. Del Grosso, 1974
New equation for the speed of sound in natural waters (with comparisons
to other equations). J. Acoust. Soc. Am 56(4) pp 1084-1091.
}

