% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sotkanet.R
\name{get_sotkanet}
\alias{get_sotkanet}
\title{Retrieve Sotkanet Data}
\usage{
get_sotkanet(
  indicators = NULL,
  years = NULL,
  genders = c("male", "female", "total"),
  regions = NULL,
  region.category = NULL,
  lang = "fi",
  user.agent = NULL,
  cache = TRUE,
  cache_dir = NULL,
  frictionless = FALSE
)
}
\arguments{
\item{indicators}{Dataset identifier(s)}

\item{years}{vector of years, for example `2015:2018` or `c(2010, 2012, ...)`. Default
value is `NULL`, which gives the data from all the available years. You can give indicators
their own year range by giving the years in a list. See examples for demonstration.}

\item{genders}{vector of genders ('male' | 'female' | 'total'). Some datasets do not
work with only the gender value 'total' and return an empty data.frame. In these situations
it is advised to check out some other alternative.}

\item{regions}{filter by selected regions only (default: all regions). The
region filter has to be given in the language used for the language variable.}

\item{region.category}{filter by one or more of the following 15 valid
regions categories (default: all categories)
   \itemize{
     \item "ALUEHALLINTOVIRASTO"
     \item "ELY-KESKUS"
     \item "ERVA"
     \item "EURALUEET" (Eurozone)
     \item "EUROOPPA" (Europe)
     \item "HYVINVOINTIALUE" (welfare country)
     \item "KUNTA" (municipality)
     \item "MAA" (country)
     \item "MAAKUNTA" (region)
     \item "NUTS1"
     \item "POHJOISMAAT" (Nordic countries)
     \item "SAIRAANHOITOPIIRI (hospital district)
     \item "SEUTUKUNTA"
     \item "SUURALUE"
     \item "YTA"
   }}

\item{lang}{Language of the data variables: indicator.title, region.title
and indicator.organization.title. Default is Finnish ("fi"), the other options being
English ("en") and Swedish ("sv").}

\item{user.agent}{"User agent" defined by the user. Default is NULL which
will then use the package identifier "rOpenGov/sotkanet"}

\item{cache}{a logical whether to do caching. Defaults is `TRUE`.}

\item{cache_dir}{a path to cache directory. `Null` (default) uses and creates
"sotkanet" directory in the temporary directory defined by base R [tempdir()]
function. The user can set the cache directory to an existing directory with this
argument.}

\item{frictionless}{a logical whether to return a datapackage, with metadata inside,
instead of a data.frame.}
}
\value{
Returns a data.frame when frictionless is `FALSE` and a datapackage
when frictionless is `TRUE`.
}
\description{
Retrieve selected data and combine into a single table.
}
\details{
THL's open data license and limitation of liability

\strong{License}

The open data provided by National Institute for Health and Welfare is
licensed under CC BY 4.0. This license defines how open data can be utilized.
The licensing is based on a decision made by the Director General.

\strong{Limitation of Liability}

National Institute for Health and Welfare shall not be liable for any loss,
legal proceedings, claims, proceedings, demands, costs or damages regardless
of their cause or form, which can be directly or indirectly connected to
open data or use of open data published by National Institute for Health and
Welfare.
}
\examples{
\dontrun{
dat <- get_sotkanet(indicators = 165)
dat <- get_sotkanet(indicators = c(4,5), genders = c("male", "female"))
dat <- get_sotkanet(indicators = 10012, regions = c("Suomi", "Ruotsi"))
dat <- get_sotkanet(indicators = 10012, region.category = c("POHJOISMAAT"))
dat <- get_sotkanet(indicators = 6, lang = "en")
dat <- get_sotkanet(indicators = 10027, frictionless = TRUE)
dat <- get_sotkanet(indicators = c(4,5,6), years = list("4" = 2000:2010,
                                                        "5" = 2010:2015, "6" = 2015:2020))
}
}
\references{
See citation("sotkanet")
}
\seealso{
For more information about dataset structure, see THL webpage at
\url{https://yhteistyotilat.fi/wiki08/pages/viewpage.action?pageId=27557907}

THL open data license website: \url{https://yhteistyotilat.fi/wiki08/x/AAadAg}
}
\author{
Maintainer: Leo Lahti \email{leo.lahti@iki.fi}, Pyry Kantanen
}
\keyword{utilities}
