% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_sparseCov.R
\name{est_sparseCov}
\alias{est_sparseCov}
\title{This function computes the thresholding sparse covariance/correlation estimator
with the optimal threshold level.}
\usage{
est_sparseCov(
  data,
  method = c("cv", "qiu"),
  operator = c("hard", "soft", "scad", "al"),
  corr = TRUE
)
}
\arguments{
\item{data}{The data matrix.}

\item{method}{The choice of method to select the optimal threshold level.}

\item{operator}{The choice of the thresholding operator.}

\item{corr}{The indicator of computing correlation or covariance matrix.}
}
\value{
The thresholding sparse covariance/correlation estimator.
}
\description{
This function computes the thresholding sparse covariance/correlation estimator
with the optimal threshold level.
}
\examples{
## generate data from a block diagonal covariance matrix structure
n <- 50
p <- 30
data.true.cov <- block.true.cov(p)
data <- sampleMVN(n, data.true.cov, sparse=TRUE)
## compute the thresholding sparse covariance/correlation estimator
s <- est_sparseCov(data, method='cv', operator='scad', corr=FALSE)
}
