% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseGFM.R
\name{eval.space}
\alias{eval.space}
\title{Evaluate Subspace Angles Between Two Matrices}
\usage{
eval.space(A, B, orthnm = TRUE)
}
\arguments{
\item{A}{First matrix (n x k)}

\item{B}{Second matrix (n x k)}

\item{orthnm}{Logical indicating whether to orthonormalize the matrices (default = TRUE)}
}
\value{
A numeric vector of length 2 containing:
\itemize{
  \item VCC: Vector Correlation Coefficient
  \item TCC: Tucker's Congruence Coefficient
}
}
\description{
Calculate the Vector Correlation Coefficient (VCC) and Tucker's Congruence Coefficient (TCC)
between two matrices to evaluate the similarity of subspaces.
}
\details{
This function computes subspace similarity measures commonly used in factor analysis
and matrix factorization to compare estimated and true factor spaces.
}
\examples{
\donttest{
# Generate example matrices
set.seed(123)
A <- matrix(rnorm(50), 10, 5)
B <- A + matrix(rnorm(50, sd = 0.1), 10, 5)  # Add small noise

# Calculate subspace angles
angles <- eval.space(A, B, orthnm = TRUE)
print(paste("VCC:", round(angles[1], 4)))
print(paste("TCC:", round(angles[2], 4)))
}

}
