% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sparsestep.R
\name{plot.sparsestep}
\alias{plot.sparsestep}
\alias{plot}
\title{Plot the SparseStep path}
\usage{
\method{plot}{sparsestep}(x, ...)
}
\arguments{
\item{x}{a \code{sparsestep} object}

\item{\dots}{further argument to matplot}
}
\description{
Plot the coefficients of the SparseStep path
}
\examples{
x <- matrix(rnorm(100*20), 100, 20)
y <- rnorm(100)
fit <- sparsestep(x, y)
plot(fit)
pth <- path.sparsestep(x, y)
plot(pth)
}
\references{
Van den Burg, G.J.J., Groenen, P.J.F. and Alfons, A. (2017).
 \emph{SparseStep: Approximating the Counting Norm for Sparse Regularization},
 arXiv preprint arXiv:1701.06967 [stat.ME]. 
 URL \url{https://arxiv.org/abs/1701.06967}.
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen, Andreas Alfons\cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
