% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{plants_rf_spatial}
\alias{plants_rf_spatial}
\title{Example fitted spatial random forest model}
\format{
An object of class \code{rf} fitted with the following parameters:
\itemize{
\item \code{data}: \link{plants_df}
\item \code{dependent.variable.name}: \link{plants_response} ("richness_species_vascular")
\item \code{predictor.variable.names}: \link{plants_predictors} (17 variables)
\item \code{distance.matrix}: \link{plants_distance}
\item \code{xy}: \link{plants_xy}
\item \code{distance.thresholds}: \code{c(100, 1000, 2000, 4000)}
\item \code{method}: "mem.effect.recursive"
\item \code{num.trees}: 50
\item \code{min.node.size}: 30
\item \code{n.cores}: 14
}
}
\usage{
data(plants_rf_spatial)
}
\description{
Fitted spatial random forest model using \link{plants_df} with spatial predictors from Moran's Eigenvector Maps. Provided for testing and examples without requiring model fitting. Fitted with reduced complexity for faster computation and smaller object size.
}
\details{
This spatial model includes spatial predictors (Moran's Eigenvector Maps) selected using the recursive method to minimize residual spatial autocorrelation. Uses reduced complexity (50 trees, min.node.size = 30) to keep object size small for package distribution. For actual analyses, use higher values (e.g., num.trees = 500, min.node.size = 5).
}
\seealso{
\code{\link[=rf_spatial]{rf_spatial()}}, \code{\link[=rf]{rf()}}, \link{plants_rf}, \link{plants_df}, \link{plants_response}, \link{plants_predictors}

Other data: 
\code{\link{plants_df}},
\code{\link{plants_distance}},
\code{\link{plants_predictors}},
\code{\link{plants_response}},
\code{\link{plants_rf}},
\code{\link{plants_xy}}
}
\concept{data}
\keyword{datasets}
