% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points_in_circle.R
\name{points_in_circle}
\alias{points_in_circle}
\title{Find points within a circle around a center coordinate}
\usage{
points_in_circle(
  data,
  lon_center,
  lat_center,
  lon = lon,
  lat = lat,
  radius = 200,
  sort = TRUE
)
}
\arguments{
\item{data}{A data frame containing at least longitude and latitude columns.}

\item{lon_center}{Numeric scalar, longitude of the circle center.}

\item{lat_center}{Numeric scalar, latitude of the circle center.}

\item{lon}{Name of the longitude column in \code{data}.}

\item{lat}{Name of the latitude column in \code{data}.}

\item{radius}{Numeric, circle radius in meters. Default is 200.}

\item{sort}{Logical, if \code{TRUE} (default) results are sorted by distance
from the center (closest first). If \code{FALSE}, the order of \code{data}
is preserved.}
}
\value{
A data frame subset of \code{data} with an extra column
  \code{distance_m} giving the distance to the center point.
}
\description{
This function selects rows from a data frame whose
longitude/latitude coordinates fall within a given radius (in meters) from a
specified center point. It also calculates the distance of each point to the
center.
}
\examples{
points_in_circle(Groningen, lon_center = 6.571561, lat_center = 53.21326,
radius = 60)

}
\author{
Martin Haringa
}
