% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_times.R
\name{group_times}
\alias{group_times}
\title{Group Times}
\usage{
group_times(DT = NULL, datetime = NULL, threshold = NULL)
}
\arguments{
\item{DT}{input data.table}

\item{datetime}{name of date time column(s). either 1 POSIXct or 2 IDate and
ITime. e.g.: 'datetime' or c('idate', 'itime')}

\item{threshold}{threshold for grouping times. e.g.: '2 hours', '10 minutes',
etc. if not provided, times will be matched exactly. Note that provided
threshold must be in the expected format: '## unit'}
}
\value{
\code{group_times} returns the input \code{DT} appended with a
\code{timegroup} column and additional temporal grouping columns to help
investigate, troubleshoot and interpret the timegroup.

The actual value of \code{timegroup} is arbitrary and represents the
identity of a given \code{timegroup} which 1 or more individuals are
assigned to. If the data was reordered, the group may change, but the
contents of each group would not.

The temporal grouping columns added depend on the \code{threshold}
provided:

\itemize{ \item \code{threshold} with unit minutes: "minutes" column added
identifying the nearest minute group for each row. \item \code{threshold}
with unit hours: "hours" column added identifying the nearest hour group
for each row. \item \code{threshold} with unit days: "block" columns added
identifying the multiday block for each row. }

A message is returned when any of these columns already exist in the input
\code{DT}, because they will be overwritten.
}
\description{
\code{group_times} groups rows into time groups. The function accepts date
time formatted data and a threshold argument. The threshold argument is used
to specify a time window within which rows are grouped.
}
\details{
The \code{DT} must be a \code{data.table}. If your data is a
\code{data.frame}, you can convert it by reference using
\code{\link[data.table:setDT]{data.table::setDT}}.

The \code{datetime} argument expects the name of a column in \code{DT} which
is of type \code{POSIXct} or the name of two columns in \code{DT} which are
of type \code{IDate} and \code{ITime}.

\code{threshold} must be provided in units of minutes, hours or days. The
character string should start with an integer followed by a unit, separated
by a space. It is interpreted in terms of 24 hours which poses the following
limitations:

\itemize{ \item minutes, hours and days cannot be fractional \item minutes
must divide evenly into 60 \item minutes must not exceed 60 \item minutes,
hours which are nearer to the next day, are grouped as such \item hours must
divide evenly into 24 \item multi-day blocks should divide into the range of
days, else the blocks may not be the same length }

In addition, the \code{threshold} is considered a fixed window throughout the
time series and the rows are grouped to the nearest interval.

If \code{threshold} is NULL, rows are grouped using the \code{datetime}
column directly.
}
\examples{
# Load data.table
library(data.table)
\dontshow{data.table::setDTthreads(1)}

# Read example data
DT <- fread(system.file("extdata", "DT.csv", package = "spatsoc"))

# Cast the character column to POSIXct
DT[, datetime := as.POSIXct(datetime, tz = 'UTC')]

group_times(DT, datetime = 'datetime', threshold = '5 minutes')

group_times(DT, datetime = 'datetime', threshold = '2 hours')

group_times(DT, datetime = 'datetime', threshold = '10 days')

}
\seealso{
\code{\link{group_pts}} \code{\link{group_lines}}
\code{\link{group_polys}}
}
\concept{Temporal grouping}
