% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{SPCDataModel-class}
\alias{SPCDataModel}
\alias{SPCDataModel-class}
\title{Data Model for SPC charts}
\description{
This is the basic structure for converting observations (data) into
updates for control charts. Classes of this type also have the
ability to generate new data sets (resampling).
}
\details{
Every element of this class has to consist of a list of the
following functions: updates, getcdfupdates, Pofdata,
resample, xiofP, which have to be of a specific form.  The arguments generally have the
following meaning: \code{xi} denotes the parameter vector needed to create
updates for running the chart from observed data, \code{data} is
observed data, \code{P} is a data model.

\itemize{
\item \code{updates(xi,data)}:  Returns updates for the chart using the parameter \code{xi} and the observed data \code{data}.
\item \code{Pofdata(data)}:  Estimates a probability model from the data.
\item xiofP(P): Computes the parameter \code{xi} needed to compute updates from an (estimated) probability model \code{P}.
\item \code{resample(P)}: Generates a new data set from the probability model \code{P}.
\item \code{getcdfupdates(P,xi,cadlag=TRUE)}: Returns the cumulative distribution function (CDF) of updates of data generated from the probability model \code{P} and computed using the parameter \code{xi}. The CDF has to be a function of one argument that also accepts vectors. If cadlag is  TRUE then the CDF is right-continuous (i.e. \eqn{F(x)=P(X\le x)}). If cadlag is FALSE then the CDF is left-continuous (i.e. \eqn{F(x) = P(X<x)}).
}
}
\seealso{
\code{\link{SPCModelNormal}},
\code{\link{SPCModelNonpar}},
\code{\link{SPCModelNonparCenterScale}}
}

