% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{SPCproperty}
\alias{SPCproperty}
\title{Computes bootstrap adjusted properties for control charts}
\usage{
SPCproperty(data, nrep = 500, chart, property, params, covprob = 0.9,
  quiet = FALSE, reportdistr = FALSE, parallel = 1)
}
\arguments{
\item{data}{The observed data.}

\item{nrep}{The number of bootstrap repetitions. Default 500.}

\item{chart}{The chart to be used.}

\item{property}{The property to be computed. A string. Must be implemented by the chart.}

\item{params}{Additional parameters for computing the property.}

\item{covprob}{The coverage probability of the adjustment. Default 0.9.}

\item{quiet}{Logical value indicating if progress bar should be suppressed. Default FALSE.}

\item{reportdistr}{Logical value indicating if the ecdf of the bootstrap distribution should be plotted. Default FALSE.}

\item{parallel}{Number of cores to use for parallel computations
(using mclapply from the package parallel). Defaults to 1. If set
to \code{Inf} then the number of cores is automatically detected
and all but one are used. Has to be set to 1 under Windows.}
}
\value{
An object of type SPCpropertyres.
}
\description{
Computes bootstrap adjusted properties for control charts.
}
\examples{
 # calibrate CUSUM chart to an in-control ARL of 100.
 # run with a larger number of replications in real examples!
 X <-  rnorm(100) #observed data
 chart <- new("SPCCUSUM",model=SPCModelNormal(Delta=1)) # CUSUM chart with normal observations
SPCproperty(data=X,nrep=15,chart=chart,property="calARL", params=list(target=100))

}
\seealso{
\code{\link{SPC2sidedconfint}}
}

