% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xj.R
\name{define_x_j}
\alias{define_x_j}
\title{Define x_j}
\usage{
define_x_j(utility, design_candidate)
}
\arguments{
\item{utility}{A named list of utility functions. See the examples and the
vignette for examples of how to define these correctly for different types
of experimental designs.}

\item{design_candidate}{The current design candidate under consideration}
}
\value{
The list x_j
}
\description{
Define x_j to use for the analytic derivatives of the variance-covariance
matrix. x_j is derived based on the provided utility functions and design
candidate using base model.matrix to automatically handle alternative
specific attributes and interaction terms
}
\details{
We can extract the attribute names for each utility function to allow us
to place the correct restrictions on the design candidate. Specifically, we
restrict all levels of unavailable attributes to zero for alternatives where
they do not feature. This is to ensure that we do not give weight when
deriving the variance-covariance matrix using \code{\link{derive_vcov}}.
Furthermore, the Xs are "sorted" using the order of the candidate set, which
ensures that when we calculate the sum of the probabilities times X, the
correct columns are added together. See \code{\link{derive_vcov}}.
}
