% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetOverpasses.R
\name{GetOverpasses}
\alias{GetOverpasses}
\title{Gets overpasses for an area of interest}
\source{
\url{https://api.spectator.earth/#satellite-overpasses}
}
\usage{
GetOverpasses(
  aoi,
  satellites = NULL,
  days_before = 0,
  days_after = 7,
  acquisitions = TRUE,
  api_key = Sys.getenv("spectator_earth_api_key")
)
}
\arguments{
\item{aoi}{'\code{sf}' (or '\code{Spatial*}') object defining the area of interest.
Can be of any geometry as only the bounding box is used.}

\item{satellites}{character vector, if specified only the listed satellites will be retrieved,
if \code{NULL} (default value) the acquisition plans for all possible satellites will be retrieved.
For simplicity, the satellites names can be abbreviated to
"S-1A", "S-1B", "S-2A", "S-2B", "L-8", "L-9" or "S1A", "S1B", "S2A", "S2B", "L8", "L9". Default: NULL}

\item{days_before}{integer indicating the number of days before the current date for which
overpasses should be computed. Default: 0}

\item{days_after}{integer indicating the number of days after the current date for which
overpasses should be computed. Default: 7}

\item{acquisitions}{logical indicating if only the overpasses when the data acquisition
will take place should be reported. Default: TRUE}

\item{api_key}{character containing your API key. Default: \code{Sys.getenv("spectator_earth_api_key")}}
}
\value{
Object of class '\code{sf}' with '\code{POLYGON}' geometry type and attributes
\describe{
\item{\code{id}}{integer identifier}
\item{\code{acquisitions}}{logical whether the overpass collects the data}
\item{\code{date}}{POSIXct timestamp of the overpass (UTC - to be checked)}
\item{\code{satellite}}{character satellite name}
}
}
\description{
Retrieves the footprint polygons of past and/or (near)future overpasses
of specified satellites over an area of interest.
}
\details{
This function requires an API key that is automatically generated for every registered account at
\url{https://app.spectator.earth}. You can find it under 'Your profile' (bottom left button).
By default, the API key is retrieved from the environment variable \code{spectator_earth_api_key},
but you can choose any other way of providing it (it is recommended \strong{NOT} to include it in your scripts).
}
\examples{
if(interactive()){
 library(sf)
 # get the Luxembourg country shape as area of interest
 boundary <- read_sf(system.file("extdata", "luxembourg.geojson", package = "spectator"))
 # look for Sentinel-2 A and B, use shorthand notation, default time frame
 pass <- GetOverpasses(boundary, satellites = "S-2", acquisitions = TRUE)
 # do some nice graphs
 library(maps)
 days <- range(as.Date(pass$date))
 satellites <- sort(unique(pass$satellite))
 map(database = "world", region = c("Belgium", "Netherlands", "Germany", "Luxembourg",
     "France", "Switzerland"), col = "lightgrey", fill = TRUE)
 plot(sf::st_geometry(boundary), add = TRUE, col = "red", border = FALSE)
 plot(sf::st_geometry(pass), add = TRUE)
 title(main = sprintf("\%s overpasses for period \%s", paste(satellites, collapse = "/"), 
                      paste(days, collapse = ":")))
 }
}
