% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compute_ephemera}
\alias{compute_ephemera}
\title{Pre-computations for \link{sped}}
\usage{
compute_ephemera(gtwid, hn, padding, spline_dim, perknot = 2)
}
\arguments{
\item{gtwid}{Object of class \link[=new_spedecon_gtwid]{spedecon_gtwid} describing the density of \eqn{Z} in the model \eqn{Y = X + Z}}

\item{hn}{Object of class \code{histogram} holding any histogram with the desired bins. The bins must be equally-spaced, i.e. \code{hn$equidist} must be \code{TRUE}, but otherwise only \code{hn$breaks} and \code{hn$mids} are used.}

\item{padding}{Support of spline space is extended by \code{padding/2} beyond the data on each side}

\item{spline_dim}{Numeric integer, dimension of spline space}

\item{perknot}{Number of positivity constraints per knot}
}
\value{
Object of class \code{spedecon_ephemera}, a list containing the pre-computed values.
}
\description{
\code{compute_ephemera()} does data-independent pre-computations for \link{sped} and can speed up repeated applications
}
\details{
The computations in \link{sped} rely on several matrices and vectors that are determined by the error density, spline space, and histogram bins, but do not depend on the data.
Computing these is the most time-intensive element of the process, so if the estimator will be applied several times to different data, but the same error density, spline space, and histogram bins (likely in simulations), gains can be had by pre-computing those matrices and vectors just one time.

For comparison, the \link{sped} function internally uses \code{padding = 0.4}, and \code{perknot = 2}.
}
\examples{
alpha <- 1e-3; n <- 1e3; s <- 0.3
Y <- rgamma(n,5,2) + rnorm(n,0,s)
gtwid <- gaussian_gtwid(sd=s)
hn <- hist(Y,breaks="FD",plot=FALSE)
ephemera <- compute_ephemera(gtwid=gtwid,hn=hn,padding=0.4,spline_dim=30,perknot=2)
sol1 <- sped(Y,gtwid,1e-3,ephemera=ephemera) # fast
sol2 <- sped(Y,gtwid,1e-3) # slow
attr(sol1,"coef") - attr(sol2,"coef")
}
\references{
Kent D, Ruppert D (2023). “Smoothness-Penalized Deconvolution (SPeD) of a Density Estimate.” \emph{Journal of the American Statistical Association}, to appear. ISSN 0162-1459, \doi{10.1080/01621459.2023.2259028}
}
