% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{xy_to_cartesian}
\alias{xy_to_cartesian}
\alias{xy_to_polar}
\alias{polar_to_cartesian}
\alias{cartesian_to_polar}
\alias{cartesian_to_xy}
\title{Transform between coordinate systems}
\usage{
xy_to_cartesian(x, y, track_index = current_track_index())

xy_to_polar(x, y, track_index = current_track_index(), flip = TRUE)

polar_to_cartesian(theta, r)

cartesian_to_polar(x, y)

cartesian_to_xy(x, y, track_index = current_track_index())
}
\arguments{
\item{x}{X-locations of the data points.}

\item{y}{Y-locations of the data points.}

\item{track_index}{Index of the track.}

\item{flip}{If it is \code{FALSE}, it returns theta for the original spiral (before flipping).}

\item{theta}{Angles, in radians.}

\item{r}{Radius.}
}
\value{
\code{xy_to_cartesian()} returns A data frame with two columns: \code{x} and \code{y}.

\code{xy_to_polar()} returns a data frame with two columns: \code{theta} (in radians) and \code{r} (the radius).

\code{polar_to_cartesian()} returns a data frame with two columns: \code{x} and \code{y}.

\code{cartesian_to_polar()} returns a data frame with two columns: \code{theta} (in radians) and \code{r} (the radius).

\code{cartesian_to_xy()} returns a data frame with two columns: \code{x} and \code{y}.
}
\description{
Transform between coordinate systems
}
\details{
There are three coordinate systems: the data coordinate system (xy), the polar coordinate system (polar)
and the canvas coordinate system (cartesian). The canvas coordinates correspond to the "native" coordinates of the viewport where the graphics are drawn.

Note different settings of \code{flip} and \code{reverse} in \code{\link[=spiral_initialize]{spiral_initialize()}} affect the conversion.

\code{xy_to_cartesian()} converts from the data coordinate system to the canvas coordinate system.

\code{xy_to_polar()} converts from the data coordinate system to the polar coordinate system.

\code{polar_to_cartesian()} converts from the polar coordinate system to the canvas coordinate system.

\code{cartesian_to_polar()} converts from the canvas coordinate system to the polar coordinate system.

\code{cartesian_to_xy()} converts from the canvas coordinate system to the data coordinate system.
The data points are assigned to the nearest inner spiral loops (if the point is located inside a certain spiral loop, the distance is zero).
}
\examples{
x = runif(2)
y = runif(2)
spiral_initialize(xlim = c(0, 1))
spiral_track(ylim = c(0, 1))
spiral_points(x, y)
xy_to_cartesian(x, y)
xy_to_polar(x, y)

x = runif(100, -4, 4)
y = runif(100, -4, 4)
spiral_initialize(xlim = c(0, 1))
spiral_track(ylim = c(0, 1))
df = cartesian_to_xy(x, y)
# directly draw in the viewport
grid.points(x, y, default.units = "native")
# check whether the converted xy are correct (should overlap to the previous points)
spiral_points(df$x, df$y, pch = 16, gp = gpar(col = 2))
}
