% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{spiral_horizon}
\alias{spiral_horizon}
\title{Draw horizon chart along the spiral}
\usage{
spiral_horizon(
  x,
  y,
  y_max = max(abs(y)),
  n_slices = 4,
  slice_size,
  pos_fill = "#D73027",
  neg_fill = "#313695",
  use_bars = FALSE,
  bar_width = min(diff(x)),
  negative_from_top = FALSE,
  track_index = current_track_index()
)
}
\arguments{
\item{x}{X-locations of the data points.}

\item{y}{Y-locations of the data points.}

\item{y_max}{Maximal absolute value on y-axis.}

\item{n_slices}{Number of slices.}

\item{slice_size}{Size of the slices. The final number of sizes is \code{ceiling(max(abs(y))/slice_size)}.}

\item{pos_fill}{Colors for positive values.}

\item{neg_fill}{Colors for negative values.}

\item{use_bars}{Whether to use bars?}

\item{bar_width}{Width of bars.}

\item{negative_from_top}{Should negative distribution be drawn from the top?}

\item{track_index}{Index of the track.}
}
\value{
A list of the following objects:
\itemize{
\item a color mapping function for colors.
\item a vector of intervals that split the data.
}
}
\description{
Draw horizon chart along the spiral
}
\details{
Since the track height is very small in the spiral, horizon chart visualization is an efficient way to visualize
distribution-like graphics.
}
\examples{
\donttest{
df = readRDS(system.file("extdata", "global_temperature.rds", package = "spiralize"))
df = df[df$Source == "GCAG", ]
spiral_initialize_by_time(xlim = range(df$Date), unit_on_axis = "months", period = "year",
    period_per_loop = 20, polar_lines_by = 360/20)
spiral_track()
spiral_horizon(df$Date, df$Mean, use_bar = TRUE)

# with legend
require(ComplexHeatmap)
spiral_initialize_by_time(xlim = range(df$Date), unit_on_axis = "months", period = "year",
    period_per_loop = 20, polar_lines_by = 360/20, 
    vp_param = list(x = unit(0, "npc"), just = "left"))
spiral_track()
lt = spiral_horizon(df$Date, df$Mean, use_bar = TRUE)
lgd = horizon_legend(lt, title = "Temperature difference")
draw(lgd, x = unit(1, "npc") + unit(2, "mm"), just = "left")
}
}
\seealso{
\code{\link[=horizon_legend]{horizon_legend()}} for generating the legend.
}
