% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\docType{data}
\name{TRACK_META}
\alias{TRACK_META}
\alias{names.TRACK_META}
\alias{$.TRACK_META}
\alias{[[.TRACK_META}
\alias{[.TRACK_META}
\alias{print.TRACK_META}
\title{Get meta data in the current track}
\format{
An object of class \code{TRACK_META} of length 1.
}
\usage{
TRACK_META

\method{names}{TRACK_META}(x)

\method{$}{TRACK_META}(x, name)

\method{[[}{TRACK_META}(x, i, exact = TRUE)

\method{[}{TRACK_META}(x, i)

\method{print}{TRACK_META}(x, ...)
}
\arguments{
\item{x}{The \code{TRACK_META} object.}

\item{name}{Name of the meta name. For all supported names, type \code{names(TRACK_META)}.}

\item{i}{Name of the meta name. For all supported names, type \code{names(TRACK_META)}.}

\item{exact}{Please ignore.}

\item{...}{Additional parameters.}
}
\description{
Get meta data in the current track
}
\details{
The variable \code{TRACK_META} can only be used to get meta data from the "current" track. If the current track
is not the one you want, you can first use \code{\link[=set_current_track]{set_current_track()}} to change the current track.

Don't directly use \code{TRACK_META}. The value of \code{TRACK_META} itself is meaningless. Always use in form of \code{TRACK_META$name}.

There are the following meta data for the current track:
\itemize{
\item \code{xlim}: Data range on x-axis.
\item \code{xmin}: \code{xlim[1]}.
\item \code{xmax}: \code{xlim[2]}.
\item \code{xrange}: \code{xlim[2] - xlim[1]}.
\item \code{xcenter}: \code{mean(xlim)}.
\item \code{theta_lim}: Range of the angles on the spiral, measured in radians.
\item \code{theta_min}: \code{theta_lim[1]}.
\item \code{theta_max}: \code{theta_lim[2]}.
\item \code{theta_range}: \code{theta_lim[2] - theta_lim[1]}.
\item \code{theta_center}: \code{mean(theta_lim)}.
\item \code{ylim}: Data range on y-axis.
\item \code{ymin}: \code{ylim[1]}.
\item \code{ymax}: \code{ylim[2]}.
\item \code{yrange}: \code{ylim[2] - ylim[1]}.
\item \code{ycenter}: \code{mean(ylim)}.
\item \code{rel_height}: Fraction of height of the track to the distance between two neighbouring loops.
\item \code{abs_height}: The height of the track, which is \code{rel_height} multiplied by the distance between two neighbouring loops.
\item \code{track_index}: Current track index.
}
}
\examples{
spiral_initialize(xlim = c(0, 1))
spiral_track(ylim = c(0, 1))
for(nm in names(TRACK_META)) {
    cat(nm, ":\n", sep = "")
    print(TRACK_META[[nm]])
    cat("\n")
}
names(TRACK_META)
}
\keyword{datasets}
