% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlrunners.R
\name{run_queries}
\alias{run_queries}
\alias{runqueries}
\title{Execute a sequence of SQL queries}
\usage{
run_queries(sql, ..., default.conn = default_conn(), include_params = FALSE)

runqueries(sql, ..., default.conn = default_conn(), include_params = FALSE)
}
\arguments{
\item{sql}{An optionally-named list or character vector containing sql
strings, or a tibble returned by \code{\link[=read_sql]{read_sql()}} or \code{\link[=prepare_sql]{prepare_sql()}}.}

\item{...}{Arguments to be passed to \code{\link[=read_sql]{read_sql()}} or \code{prepare_sql()}}

\item{default.conn}{Either the name of a sqlhelper connection, or a database
connection returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}} or \code{\link[pool:dbPool]{pool::dbPool()}}. This
connection is used as a fall-back when the \code{sql} parameter is a tibble and
no per-query connection name is supplied, or the connection name is
\code{default} (see \code{\link[=prepare_sql]{prepare_sql()}}). It may be used by \code{\link[glue:glue_sql]{glue::glue_sql()}} to
interpolate SQL strings, and as the connection against which to execute SQL
queries.}

\item{include_params}{\code{TRUE} or \code{FALSE}. Should the parameters be
included in the output? Mainly useful for debugging.}
}
\value{
\itemize{
\item If \code{include_params} is \code{FALSE} and the \code{sql} argument is a
vector, a list containing the results of each query; element names will be
taken from the \code{sql} argument.
\item If the length of the \code{sql} argument is 1 and is not named, the result of
that query is returned as-is (e.g. a data.frame), not as a 1-element list.
\item If \code{include_params} is \code{TRUE}, a tibble is returned containing 1
row per query with the following fields:
}

\describe{
\item{qname}{character. A name for this query}
\item{quotesql}{"yes" or "no". Should parameterized character values be quoted for this query?}
\item{interpolate}{"yes" or "no". Should this query be parameterized with values from R?}
\item{execmethod}{The method to execute this query.
One of "get" (\code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}), "execute" (\code{\link[DBI:dbExecute]{DBI::dbExecute()}}), "sendq" (\code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}), "sends" (\code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}) or "spatial" (\code{\link[sf:st_read]{sf::st_read()}})}
\item{geometry}{character. If \code{execmethod} is "spatial", this should be the name of the geometry column.}
\item{conn_name}{character. The name of the database connection against which to execute this query.
Must be the name of a configured sqlhelper connection.}
\item{sql}{The sql query to be executed}
\item{filename}{The value of \code{file_name}}
\item{prepared_sql}{The sql query to be executed, i.e. with interpolations
and quoting in place}
\item{result}{The result of the query}
}
}
\description{
Accepts a character vector of SQL queries and attempts to execute each
}
\details{
If no default connection is supplied via \code{default.conn} and no
connections have been configured using \code{connect()}, an attempt will be made
to configure connections via \code{connect()} using the configuration search
path. If no database connections are available after this attempt, an error
will be raised. See \code{vignette("connections")} for details about the
configuration search path.
}
\examples{
library(sqlhelper)

readLines(
    system.file("examples/sqlhelper_db_conf.yml",
                package="sqlhelper")
    ) |>
writeLines()

connect(
    system.file("examples/sqlhelper_db_conf.yml", package="sqlhelper"),
    exclusive=TRUE)

DBI::dbWriteTable( default_conn(),
                  "iris",
                  iris)

n <- 5

run_queries(
    c(top_n = "select * from iris limit {n}",
      uniqs = "select distinct species as species from iris")
)

## use include_params to review the execution context
run_queries(
    c(top_n = "select * from iris limit {n}",
      uniqs = "select distinct species as species from iris"),
   include_params = TRUE
)

## pass an env of interpolation values to the 'values' parameter
## result of a single, unnamed query is returned as an object, not a
## 1-element list
e <- new.env()
e$n <- 2
run_queries(
    "select * from iris limit {n}",
    values = e
)

## Use the execmethod parameter for statements
run_queries("create table iris_setosa as select * from iris where species = 'setosa'",
          execmethod = 'execute')

run_queries("select distinct species as species from iris_setosa")

}
\seealso{
\code{\link[=read_sql]{read_sql()}}, \code{\link[=prepare_sql]{prepare_sql()}}

Other SQL runners: 
\code{\link{run_files}()}
}
\concept{SQL runners}
