#' Empty token class.
#'
#' This class represents an empty SQL token. It is used in situations where
#' a token is required by the structure of the code, but no actual SQL code
#' needs to be generated.
#'
#' @examples
#' # No example since this class is not exported.
#'
#' @import R6
#' @include Token.R
TokenEmpty <- R6::R6Class("TokenEmpty",
  inherit = Token,
  public = list(

    #' @description
    #' Initializer.
    #' @return Nothing.
    initialize = function() {
      return(invisible(NULL))
    },

    #' @description
    #' Converts into a string.
    #' @return A string containing the SQL expression.
    toString = function() {
      return("")
    }
  )
)
