# Optional space
optspace <- function() {
  return(if (getOption("sqlq_spaces", TRUE)) .spc else .void)
}

# Left token
make_left_op <- function(symb) {
  chk::chk_string(symb)

  # Alphabetical symbol (OR, AND, ...) needs spaces around
  if (grepl("^[A-Za-z]+$", symb)) {
    tokens <- list(TokenKeyword$new(symb), .spc)
  } else {
    tokens <- list(TokenSymbol$new(symb), optspace())
  }

  return(tokens)
}

# Middle token
make_middle_op <- function(symb) {
  chk::chk_string(symb)

  # Alphabetical symbol (OR, AND, ...) needs spaces around
  if (grepl("^[A-Za-z]+$", symb)) {
    tokens <- list(.spc, TokenKeyword$new(symb), .spc)
  } else {
    tokens <- list(optspace(), TokenSymbol$new(symb), optspace())
  }

  return(tokens)
}
