testthat::context("ExprCommOp class")

testthat::test_that("Initializer works fine", {
  testthat::expect_error(ExprCommOp$new())
  ExprCommOp$new("OR")
})

testthat::test_that("Conversion to string works fine", {
  x <- ExprCommOp$new("OR")
  testthat::expect_equal(x$toString(), "")

  x$add(ExprValue$new("a"))
  testthat::expect_equal(x$toString(), "('a')")

  x$add(ExprValue$new("b"))
  testthat::expect_equal(x$toString(), "('a' OR 'b')")

  testthat::expect_equal(x$nb_expr(), 2)
})

testthat::test_that("We can build a where clause form a list of values", {
  patterns <- c("A%", "D%", "Z%")
  author <- ExprField$new("author")
  cond <- ExprCommOp$new(
    "or",
    lapply(
      patterns,
      function(x) {
        ExprBinOp$new(
          author, "like",
          ExprValue$new(x)
        )
      }
    )
  )
  where <- StmtWhere$new(cond)
  query <- make_select_all("books", where = where)
  testthat::expect_equal(
    query$toString(),
    paste(
      "SELECT * FROM books WHERE (author LIKE 'A%')",
      "OR (author LIKE 'D%') OR (author LIKE 'Z%');"
    )
  )
})
