% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_seeds_score}
\alias{get_seeds_score}
\title{Calculate the local wight of seed nodes.}
\usage{
get_seeds_score(net_data, seed, mut_gene, BC_Num, cut_point = 0)
}
\arguments{
\item{net_data}{A list of the PPI network information, including nodes and edges.}

\item{seed}{A vector containing the gene symbols of the seed nodes.}

\item{mut_gene}{A vector containing the gene symbols of the mutated genes in a single sample.}

\item{BC_Num}{Number of background genes.}

\item{cut_point}{The threshold of indicator function.}
}
\value{
A data frame containing the weight of seed nodes.
}
\description{
The function `get_seeds_score` is used to calculate the local wight of seed nodes in a single sample.
}
\examples{
#load the data
net_path <- system.file("extdata","ppi_network.Rdata",package = "ssMutPA")
load(net_path)
data(mut_status)
seed<-intersect(names(mut_status[,1])[which(mut_status[,1]!=0)],igraph::V(ppi_network)$name)
mut_gene<-intersect(names(mut_status[,1])[which(mut_status[,1]!=0)],igraph::V(ppi_network)$name)
#perform the function `get_seeds_score`.
Seeds_Score<-get_seeds_score(net_data=ppi_network,seed=seed,mut_gene,BC_Num=12436,cut_point=0)
}
