% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{package}
\name{ssmodels}
\alias{ssmodels-package}
\alias{ssmodels}
\title{ssmodels: Sample Selection Models in R}
\description{
The \code{ssmodels} package provides functions to fit data affected by sample selection bias.
It includes several extensions of the classical Heckman selection model, allowing for different
assumptions about the joint distribution of the selection and outcome equations.
}
\details{
The following models are implemented:
\describe{
  \item{\code{HeckmanCL}}{Classic Heckman model (Tobit-2).}
  \item{\code{HeckmantS}}{Heckman model with Student's t-distribution.}
  \item{\code{HeckmanSK}}{Heckman model with Skew-Normal distribution.}
  \item{\code{HeckmanBS}}{Heckman model with Birnbaum-Saunders distribution.}
  \item{\code{HeckmanGe}}{Generalized Heckman model with covariates in the dispersion
  and correlation structures.}
}

The package also includes helper functions for computing Inverse Mills Ratios (IMR),
post-processing parameter vectors, and two-step initial value estimation.
}
\references{
\insertRef{heckman1976common}{ssmodels}

\insertRef{heckman1979sample}{ssmodels}

\insertRef{mroz1987}{ssmodels}

\insertRef{sampleSelection}{ssmodels}

\insertRef{marchenko2012heckman}{ssmodels}

\insertRef{ogundimu2016sample}{ssmodels}

\insertRef{zhelonkin2016robust}{ssmodels}

\insertRef{ssmrob}{ssmodels}

\insertRef{ogundimu2019robust}{ssmodels}

\insertRef{bastos}{ssmodels}

\insertRef{bastosBarreto}{ssmodels}
}
\seealso{
\code{\link{HeckmanCL}}, \code{\link{HeckmantS}}, \code{\link{HeckmanSK}},
\code{\link{HeckmanBS}}, \code{\link{HeckmanGe}}
}
\author{
Fernando de Souza Bastos, Wagner Barreto de Souza
}
\keyword{Heckman}
\keyword{econometrics}
\keyword{likelihood}
\keyword{maximum}
\keyword{sample}
\keyword{selection}
