% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indiv_anova.R
\name{indiv_anova}
\alias{indiv_anova}
\alias{indiv_anova.default}
\title{Individual ANOVA for Each Environment}
\usage{
\method{indiv_anova}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Additive ANOVA
}
\description{
Individual ANOVA for Each Environment
}
\examples{

data(ge_data)
Yield.indiv_anova <-
         indiv_anova(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
          )
Yield.indiv_anova


}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         \item Ghulam Murtaza (\email{gmurtaza208@gmail.com})
         }
}
