% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/developmentFunction.R
\name{develFuncDefault}
\alias{develFuncDefault}
\alias{develFunc}
\alias{developmentFunction}
\title{Development Function}
\usage{
develFuncDefault(stage, x, time, species, strain)
}
\arguments{
\item{stage}{(integer). The numbered life stage for which to return a developement rate.}

\item{x}{Vector of state variables within the DDE solver. To access a variable use:
x$speciesName['stageName',strainNumber]
e.g. for species 'Bacteria', stage 'reproductive', strain 2 use
x$Bacteria['reproductive',2]
If there is only one stage and strain in species 'Food', for example, use
x$Food[1,1]}

\item{time}{(scalar). The current time point in the DDE solver.}

\item{species}{(integer). The numbered species for which to return a development rate.}

\item{strain}{(integer). The numbered strain for which to return a developement rate.}
}
\value{
Development rate (units of inverse time) for the strain, stage, species and time specified.
}
\description{
Return the rate of development (per unit time)
}
\details{
This function will only be called
when the \code{timeDependDuration} argument to
\code{\link{popModel}} contains TRUE values, otherwise the
development rate within a stage is irrelevant to the model.
}
