% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_matrices.R
\name{ci_matrices}
\alias{ci_matrices}
\title{Conditional independences matrices of stages}
\usage{
ci_matrices(object, var)
}
\arguments{
\item{object}{an object of class \code{sevt}.}

\item{var}{string, the name of one of the variables in \code{object}.}
}
\value{
A list with \code{i-1} matrices, where \code{i} is the depth
of variable \code{var} in the tree.
}
\description{
Generate the sequence of all the
conditional independences
matrices of stages for a given variable in the model.
}
\examples{
mod <- sevt(list(A = c("a", "aa"),
                 B = c("b", "bb", "bbb"),
                 C = c("c", "cc")), full = TRUE)
stages(mod)["C", A = "a", B = c("b", "bb")] <- "stage1"
stages(mod)["C", A = "aa"] <- "stage2"
stages(mod)["C", A = "a", B = "bbb"] <- "stage2"

ci_matrices(mod, "C")
}
