% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probdist.R
\name{probdist}
\alias{probdist}
\alias{probdist.l2}
\alias{probdist.l1}
\alias{probdist.ry}
\alias{probdist.kl}
\alias{probdist.tv}
\alias{probdist.hl}
\alias{probdist.bh}
\alias{probdist.cd}
\title{Distances between probabilities}
\usage{
probdist.l2(x, y)

probdist.l1(x, y)

probdist.ry(x, y)

probdist.kl(x, y)

probdist.tv(x, y)

probdist.hl(x, y)

probdist.bh(x, y)

probdist.cd(x, y)
}
\arguments{
\item{x}{vector of probabilities.}

\item{y}{vector of probabilities.}
}
\value{
The distance between \code{p} and \code{q}
}
\description{
Distances between probabilities
}
\details{
Functions to compute distances between probabilities:
\itemize{
\item \code{lp}: the \eqn{L^p} distance, \eqn{||x - y||_p^p} for \eqn{p = 1,2}
\item \code{ry}: the symmetric Renyi divergence of order \eqn{\alpha = 2}
\item \code{kl}: the symmetrized Kullback-Leibler divergence
\item \code{tv}: the total variation or \eqn{L^1} norm
\item \code{hl}: the (squared) Hellinger distance
\item \code{bh}: the Bhattacharyya distance
\item \code{cd}: the Chan-Darwiche distance
}
}
\keyword{internal}
