% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{startup.options}
\alias{startup.options}
\alias{R_STARTUP_CHECK}
\alias{startup.check}
\alias{R_STARTUP_CHECK_OPTIONS_IGNORE}
\alias{startup.check.options.ignore}
\alias{startup.commandArgs}
\alias{R_STARTUP_DEBUG}
\alias{startup.debug.file}
\alias{R_STARTUP_DEBUG_FILE}
\alias{startup.debug}
\alias{R_STARTUP_DRYRUN}
\alias{startup.dryrun}
\alias{R_STARTUP_DISABLE}
\alias{startup.disable}
\alias{R_STARTUP_FILE}
\alias{startup.file}
\alias{R_STARTUP_INIT}
\alias{startup.init}
\alias{R_STARTUP_RDATA}
\alias{startup.rdata}
\alias{R_STARTUP_TIME}
\alias{startup.time}
\title{Options and environment variables used by the 'startup' package}
\description{
Below are environment variables and \R options that are used by the
\pkg{startup} package.
The \env{R_STARTUP_***} environment variables must be set before calling
the \code{startup::startup()} function, that is, either (i) prior to launching
\R or (ii) in the \file{.Renviron} file.
}
\section{Controls whether \pkg{startup} is used or not}{


\describe{
\item{\env{R_STARTUP_DISABLE} / \option{startup.disable}:}{
(logical)
If \code{TRUE}, \code{startup::startup()} is fully disable such that \emph{no}
\file{.Renviron.d/} or \file{.Rprofile.d/} files are processed.
\emph{Note}: Files \file{.Renviron} and \file{.Rprofile} are still processed
because these are out of control of the \pkg{startup} package.
(Default: \code{FALSE})
}

\item{\env{R_STARTUP_DRYRUN} / \option{startup.dryrun}:}{
(logical)
Controls the default value of argument \code{dryrun} of \code{\link[=startup]{startup()}}.
(Default: \code{FALSE})
}
}
}

\section{Additional customization of the startup process}{


\describe{
\item{\env{R_STARTUP_FILE} / \option{startup.file}:}{
(R script as a character string)
Optional \R script that is parsed and evaluated after
\file{.Renviron.d/} and \file{.Rprofile.d/} files,
and \code{R_STARTUP_INIT} code, have been processed, e.g.
\verb{R_STARTUP_FILE="setup.R" R --quiet}.
(Default: not specified)
}

\item{\env{R_STARTUP_INIT} / \option{startup.init}:}{
(R code as a character string)
Optional \R code that is parsed and evaluated after
\file{.Renviron.d/} and \file{.Rprofile.d/} files,
but before \code{R_STARTUP_FILE} code, have been processed e.g.
\verb{R_STARTUP_INIT="message('Hello world')" R --quiet}.
The specified string must be parsable by \code{\link[base:parse]{base::parse()}}.
(Default: not specified)
}

\item{\env{R_STARTUP_RDATA} / \option{startup.rdata}:}{
(comma-separated values)
Controls whether an existing \file{./.RData} file should be processed
or not.
If \code{"remove"}, it will be skipped by automatically removing it.
If \code{"rename"}, it will be renamed to \file{./.RData.YYYYMMDD_hhmmss}
where the timestamp is the last time the file was modified.
If \code{"prompt"}, the user is prompted whether they want to load the file
or rename it. In non-interactive session, \code{"prompt"} will fallback to
loading the content (default). To fallback to renaming the file, use
\code{"prompt,rename"}.
If \code{"warn"}, a warning will be produced, but content is still loaded.
Note that in contrast to \code{R} and \verb{R CMD BATCH file.R}, \code{Rscript} does
\emph{not} load \file{.RData} files unless command-line option \code{--restore}
is specified.
(Default: not specified)
}
}
}

\section{Controls what validation checks are performed at startup}{


\describe{
\item{\env{R_STARTUP_CHECK} / \option{startup.check}:}{
(logical)
Controls the default value of argument \code{check} of \code{\link[=startup]{startup()}}.
(Default: \code{TRUE})
}

\item{\env{R_STARTUP_CHECK_OPTIONS_IGNORE} /
\option{startup.check.options.ignore}:}{
(character vector or comma-separated character string)
Names of \R options that should \emph{not} be validated at the end of the
\code{\link[=startup]{startup()}} process.
(Default: \code{"error"})
}
}
}

\section{Settings useful for debugging and prototyping}{


\describe{

\item{\env{R_STARTUP_DEBUG} / \option{startup.debug}:}{
(logical)
Controls the default value of argument \code{debug} of \code{\link[=startup]{startup()}}.
(Default: \code{FALSE})
}

\item{\env{R_STARTUP_DEBUG_FILE} / \option{startup.debug.file}:}{
(character string or NULL)
Controls where \code{\link[=startup]{startup()}} debug messages are outputted.
If set, it specifies the file where debug messages are written to.
If file already exists, it is overwritten.
Unless an absolute filename is given, the location of the file is
relative to the working directory where R was started.
If the filename comprise the string \code{{{pid}}}, it is replaced by
the R process' process identifier (PID) per \code{Sys.getpid()}.
If \code{NULL} or \verb{<message>}, then debug is outputted using the
\code{message()} function.
(Default: not specified)
}

\item{\option{startup.commandArgs}:}{
(character vector)
Overrides the command-line arguments that \code{\link[=startup]{startup()}} uses, which
can be useful to prototype and test alternative ways that \R might
be launched.
(Default: \code{base::commandArgs()})
}

\item{\env{R_STARTUP_TIME} / \option{startup.time}:}{
(POSIX timestamp; character string)
Overrides the current timestamp, which can be useful to prototype and
test functionalities that depend on the current time, e.g. inclusion
and exclusion of files based on \verb{when=<periodicity>} tags.
The specified string must be parsable by \code{\link[base:as.POSIXlt]{base::as.POSIXct()}}.
(Default: not specified)
}
}
}

