% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{enlist}
\alias{enlist}
\title{Wrap an object into a singleton list if not already a list}
\usage{
enlist(x, test = c("inherits", "vector", "list"))
}
\arguments{
\item{x}{an object to be wrapped.}

\item{test}{how a string or a function to decide whether an object
counts as a list; see Details.}
}
\description{
This function tests whether its first argument is a list according
to the specified criterion; if not, puts it into a list of length 1.
}
\details{
\code{test} can be one of the following \describe{

\item{\code{"inherits"}}{use \code{\link{inherits}}\verb{(x, "list")}. This will
require the object to have class \code{list} and is generally the
strictest (i.e., will wrap the most objects).}

\item{\code{"list"}}{use \code{\link{is.list}}\code{(x)}. This will treat S3 objects
based on lists as lists.}

\item{\code{"vector"}}{use \code{\link{is.vector}}\code{(x)}. This will treat atomic
vectors and \code{\link{expression}}s as lists.}

\item{a function with 1 argument}{call \code{as.logical(test(x))}; if
\code{TRUE}, the object is treated as a list; otherwise not.}

}
}
\examples{

data(mtcars)
stopifnot(
  # Atomic vectors don't inherit from lists.
  identical(enlist(1:3), list(1:3)),
  # Atomic vectors are not lists internally.
  identical(enlist(1:3, "list"), list(1:3)),
  # Atomic vectors are a type of R vector.
  identical(enlist(1:3, "vector"), 1:3),
  # Data frames don't inherit from lists.
  identical(enlist(mtcars), list(mtcars)),
  # Data frames are lists internally.
  identical(enlist(mtcars, "list"), mtcars),
  # Data frames are not considered R vectors.
  identical(enlist(mtcars, "vector"), list(mtcars))
)

# We treat something as a "list" if its first element is odd.
is.odd <- function(x) as.logical(x[1] \%\% 2)
stopifnot(
  # 1 is a list.
  identical(enlist(1, is.odd), 1),
  # 2 is not.
  identical(enlist(2, is.odd), list(2))
)

}
