% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_stcos.R
\name{gibbs_stcos}
\alias{gibbs_stcos}
\alias{logLik.stcos_gibbs}
\alias{DIC.stcos_gibbs}
\alias{print.stcos_gibbs}
\alias{fitted.stcos_gibbs}
\alias{predict.stcos_gibbs}
\title{Gibbs Sampler for STCOS Model}
\usage{
gibbs_stcos(
  z,
  v,
  H,
  S,
  Kinv,
  R,
  report_period = R + 1,
  burn = 0,
  thin = 1,
  init = NULL,
  fixed = NULL,
  hyper = NULL
)

\method{logLik}{stcos_gibbs}(object, ...)

\method{DIC}{stcos_gibbs}(object, ...)

\method{print}{stcos_gibbs}(x, ...)

\method{fitted}{stcos_gibbs}(object, H, S, ...)

\method{predict}{stcos_gibbs}(object, H, S, ...)
}
\arguments{
\item{z}{Vector which represents the outcome; assumed to be direct
estimates from the survey.}

\item{v}{Vector which represents direct variance estimates from the survey.}

\item{H}{Matrix of overlaps between source and fine-level supports.}

\item{S}{Design matrix for basis decomposition.}

\item{Kinv}{The precision matrix \eqn{\bm{K}^{-1}} of the
random coefficient \eqn{\bm{\eta}}}

\item{R}{Number of MCMC reps.}

\item{report_period}{Gibbs sampler will report progress each time this many
iterations are completed.}

\item{burn}{Number of the \code{R} draws to discard at the beginning of the
chain.}

\item{thin}{After burn-in period, save one out of every \code{thin} draws.}

\item{init}{A list containing the following initial values for the MCMC:
\code{sig2mu}, \code{sig2xi}, \code{sig2K}, \code{muB}, \code{eta},
\code{xi}. Any values which are not specified are set to arbitrary
choices.}

\item{fixed}{A list specifying which parameters to keep fixed in the MCMC.
This can normally be left blank. If elements \code{sig2mu},
\code{sig2xi}, or \code{sig2K} are specified they should be boolean,
where TRUE means fixed (i.e. not drawn). If elements \code{muB},
\code{eta}, or \code{xi} are specified, they should each be a vector
of indicies; the specified indices are to be treated as fixed (i.e.
not drawn).}

\item{hyper}{A list containing the following hyperparameter values:
\code{a_sig2mu}, \code{a_sig2K}, \code{a_sig2xi}, \code{b_sig2mu},
\code{b_sig2K}, \code{b_sig2xi}. Any hyperparameters which are not
specified are set to a default value of 2.}

\item{object}{A result from \code{gibbs_stcos}.}

\item{...}{Additional arguments.}

\item{x}{A result from \code{gibbs_stcos}.}
}
\value{
\code{gibbs_stcos} returns an \code{stcos} object which contains
draws from the sampler. Helper functions take this object as an input
and produce various outputs (see details).
}
\description{
Gibbs Sampler for STCOS Model
}
\details{
Fits the model
\deqn{
  \bm{Z} = \bm{H} \bm{\mu}_B + \bm{S} \bm{\eta} + \bm{\xi} + \bm{\varepsilon}, \quad
  \bm{\varepsilon} \sim \textrm{N}(0, \bm{V}),
}
\deqn{
  \bm{\eta} \sim \textrm{N}(\bm{0}, \sigma_K^2 \bm{K}), \quad
  \bm{\xi} \sim \textrm{N}(0, \sigma_{\xi}^2 \bm{I}),
}
\deqn{
\bm{\mu}_B \sim \textrm{N}(\bm{0}, \sigma_\mu^2 \bm{I}), \quad
\sigma_\mu^2 \sim \textrm{IG}(a_\mu, b_\mu),
}
\deqn{
\sigma_K^2 \sim \textrm{IG}(a_K, b_K), \quad
\sigma_\xi^2 \sim \textrm{IG}(a_\xi, b_\xi),
}
using a Gibbs sampler with closed-form draws.

Helper functions produce the following outputs:
\itemize{
\item \code{logLik} computes the log-likelihood for each saved draw.
\item \code{DIC} computes the Deviance information criterion for each saved draw.
\item \code{print} displays a summary of the draws.
\item \code{fitted} computes the mean \eqn{E(Y_i)} for each observation
      \eqn{i = 1, \ldots, n}, for each saved draw.
\item \code{predict} draws \eqn{Y_i} for each observation
      \eqn{i = 1, \ldots, n}, using the parameter values for each saved
      Gibbs sampler draw.
}
}
\examples{
\dontrun{
demo = prepare_stcos_demo()
out = gibbs_stcos(demo$z, demo$v, demo$H, demo$S, solve(demo$K),
    R = 100, burn = 0, thin = 1)
print(out)
logLik(out)
DIC(out)
fitted(out, demo$H, demo$S)
predict(out, demo$H, demo$S)
}
}
