% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcov.R
\name{stein_eig}
\alias{stein_eig}
\title{Stein's raw (unisotonized) eigenvalue estimates}
\usage{
stein_eig(l, n)
}
\arguments{
\item{l}{Sample eigenvalues}

\item{n}{Number of observations}
}
\value{
Estimated eigenvalues
}
\description{
Stein's raw (unisotonized) eigenvalue estimates
}
\examples{
p <- 5
n <- 10
S <- rWishart(1, n, diag(p))[,,1]
l <- eigen(S)$val
stein_eig(l, n)
}

