% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{Person}
\alias{Person}
\title{A person (alive, dead, undead, or fictional).}
\usage{
Person(
  address,
  affiliations,
  alternateNames,
  description,
  emails,
  familyNames,
  funders,
  givenNames,
  honorificPrefix,
  honorificSuffix,
  id,
  identifiers,
  images,
  jobTitle,
  memberOf,
  meta,
  name,
  telephoneNumbers,
  url
)
}
\arguments{
\item{address}{Postal address for the person.}

\item{affiliations}{Organizations that the person is affiliated with.}

\item{alternateNames}{Alternate names (aliases) for the item.}

\item{description}{A description of the item.}

\item{emails}{Email addresses for the person.}

\item{familyNames}{Family name. In the U.S., the last name of a person.}

\item{funders}{A person or organization that supports (sponsors) something through some kind of financial contribution.}

\item{givenNames}{Given name. In the U.S., the first name of a person.}

\item{honorificPrefix}{An honorific prefix preceding a person's name such as Dr/Mrs/Mr.}

\item{honorificSuffix}{An honorific suffix after a person's name such as MD/PhD/MSCSW.}

\item{id}{The identifier for this item.}

\item{identifiers}{Any kind of identifier for any kind of Thing.}

\item{images}{Images of the item.}

\item{jobTitle}{The job title of the person (for example, Financial Manager).}

\item{memberOf}{An organization (or program membership) to which this person belongs.}

\item{meta}{Metadata associated with this item.}

\item{name}{The name of the item.}

\item{telephoneNumbers}{Telephone numbers for the person.}

\item{url}{The URL of the item.}
}
\value{
A \code{list} of class \code{Person}
}
\description{
A person (alive, dead, undead, or fictional).
}
\examples{
Person(
  honorificPrefix = "Dr",
  givenNames = list("Jane", "J"),
  familyNames = list("Jamieson")
)
}
\seealso{
\code{\link{Thing}}
}
