% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{VideoObject}
\alias{VideoObject}
\title{A video file.}
\usage{
VideoObject(
  contentUrl,
  about,
  alternateNames,
  authors,
  bitrate,
  caption,
  comments,
  content,
  contentSize,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  embedUrl,
  format,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  thumbnail,
  title,
  transcript,
  url,
  version
)
}
\arguments{
\item{contentUrl}{URL for the actual bytes of the media object, for example the image file or video file.  \bold{Required}.}

\item{about}{The subject matter of the content.}

\item{alternateNames}{Alternate names (aliases) for the item.}

\item{authors}{The authors of this creative work.}

\item{bitrate}{Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).}

\item{caption}{The caption for this video recording.}

\item{comments}{Comments about this creative work.}

\item{content}{The structured content of this creative work c.f. property \code{text}.}

\item{contentSize}{File size in megabits (Mbit, Mb).}

\item{dateAccepted}{Date/time of acceptance.}

\item{dateCreated}{Date/time of creation.}

\item{dateModified}{Date/time of most recent modification.}

\item{datePublished}{Date of first publication.}

\item{dateReceived}{Date/time that work was received.}

\item{description}{A description of the item.}

\item{editors}{People who edited the \code{CreativeWork}.}

\item{embedUrl}{URL that can be used to embed the media on a web page via a specific media player.}

\item{format}{Media type (MIME type) as per http://www.iana.org/assignments/media-types/media-types.xhtml.}

\item{fundedBy}{Grants that funded the \code{CreativeWork}; reverse of \code{fundedItems}.}

\item{funders}{People or organizations that funded the \code{CreativeWork}.}

\item{genre}{Genre of the creative work, broadcast channel or group.}

\item{id}{The identifier for this item.}

\item{identifiers}{Any kind of identifier for any kind of Thing.}

\item{images}{Images of the item.}

\item{isPartOf}{An item or other CreativeWork that this CreativeWork is a part of.}

\item{keywords}{Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.}

\item{licenses}{License documents that applies to this content, typically indicated by URL.}

\item{maintainers}{The people or organizations who maintain this CreativeWork.}

\item{meta}{Metadata associated with this item.}

\item{name}{The name of the item.}

\item{parts}{Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.}

\item{publisher}{A publisher of the CreativeWork.}

\item{references}{References to other creative works, such as another publication, web page, scholarly article, etc.}

\item{text}{The textual content of this creative work.}

\item{thumbnail}{Thumbnail image of this video recording.}

\item{title}{The title of the creative work.}

\item{transcript}{The transcript of this video recording.}

\item{url}{The URL of the item.}

\item{version}{The version of the creative work.}
}
\value{
A \code{list} of class \code{VideoObject}
}
\description{
A video file.
}
\seealso{
\code{\link{MediaObject}}
}
