% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sticky.R
\name{sticky}
\alias{sticky}
\alias{unstick}
\alias{unsticky}
\alias{is.sticky}
\alias{sticky_all}
\title{sticky}
\usage{
sticky(x)

unstick(x)

unsticky(x)

is.sticky(x)

sticky_all(x)
}
\arguments{
\item{x}{objects to have attributes preserved.}
}
\description{
Persist Attributes
}
\details{
\code{sticky} creates objects whose attributes are resilient to subsetting and
placing in containers such as lists, data.frames and data.tables.
}
\examples{

  x <- 1:5
  attr(x, 'foo') <- 'bar'
  x <- x[1:3]
  attr(x,'foo')            # NULL

  x <- sticky(1:5)
  attr(x, 'foo') <- 'bar'
  x_1 <- x[1:3]
  attr(x_1, 'foo')         # bar

  x_2 <- unstick(x)
  x_2 <- x[1:3]
  attr(x_2,'foo')          # NULL


  is.sticky(x)             # TRUE

}
\references{
This has been asked and written about numerous times on Stack Overflow. The
  first has a fairly comprehensive list to others SO discussions.

  \url{http://stackoverflow.com/questions/23991060/loss-of-attributes-despite-attempts-to-preserve-them} \cr
  \url{http://stackoverflow.com/questions/10404224/how-to-delete-a-row-from-a-data-frame-without-losing-the-attributes} \cr
  \url{http://stackoverflow.com/questions/23991060/loss-of-attributes-despite-attempts-to-preserve-them} \cr
  \url{http://stackoverflow.com/questions/23841387/approaches-to-preserving-objects-attributes-during-extract-replace-operations} \cr
  \url{http://stackoverflow.com/questions/13432519/indexing-operation-removes-attributes} \cr
}
