% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stim.R
\name{stim}
\alias{stim}
\title{Estimate a Stability Informed Model}
\usage{
stim(data = NULL, S = NULL, n = NULL, model, stability)
}
\arguments{
\item{data}{A dataframe with the measured variables. Not needed if S is provided}

\item{S}{A covariance matrix for the measured variables. Not needed if data is provided.}

\item{n}{Number of observations. Not needed if data is provided.}

\item{model}{An object with the cross-sectional model description in lavaan syntax}

\item{stability}{An object that contains stability information for each
variable in the model.}
}
\value{
An object of class stim
}
\description{
Estimate a Stability Informed Model
}
\examples{

model <- 'Y~X'
stability <- data.frame(X = .3, Y = .3)
dat <- data.frame(Y = rnorm(500, 0, 1), X = rnorm(500, 0, 1))

stim(data = dat, model = model, stability = stability)
}
