#' @export

#' @title Probability transition density function for von Mises process
#' @name dvmp
#' @description `dvmp` evaluates the transition density for von Mises process
#' @usage dvmp(theta, t, theta_0, lambda, sigma, mu)
#' @param theta vector of data
#' @param t time step \eqn{\Delta t}
#' @param theta_0 initial value
#' @param lambda lambda
#' @param sigma sigma
#' @param mu mu
#' @details See section 2 of Majumdar and Laha (2024) <doi:10.48550/arXiv.2412.06343>.
#' @return `dvmp` gives the transition density function of the von Mises process


dvmp <- function(theta, t, theta_0, lambda, sigma, mu) {
  nc <- length(theta)
  a <- rep(0, nc)
  for (i in 1:nc) {
    a[i] <- vmp_tpd(t, theta[i], theta_0, lambda, sigma, mu)
  }
  return(a)
}
