#include <Rcpp.h>
#include <math.h>
#include <cmath>
#include "pi_range.h"
#include "cbm_tpd.h"

// [[Rcpp::export]]

Rcpp::NumericVector sim_cbm_tpd(double length_sim, double theta_0, double dt, double sigma_wn){
  Rcpp::NumericVector theta (1, theta_0);
  double alpha;
  double rand_sim;
  Rcpp::NumericVector u_sample (0);
  int n;
  while(theta.length()<length_sim){
    n = theta.length();
    rand_sim = pi_range(R::rnorm(theta[n-1],1));
    alpha = cbm_tpd(dt,rand_sim,theta_0,sigma_wn)/cbm_tpd(dt,theta[n-1],theta_0,sigma_wn);
    u_sample = Rcpp::runif(1);
    if(u_sample[0]<alpha){
        theta.push_back(rand_sim);
    }
  }
  return theta;
}
