% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/33_trailingPEbasicEPS.R
\name{trailingPEbasicEPS}
\alias{trailingPEbasicEPS}
\title{Calculates trailing Price to Earnings Multiple based on basic Earnings Per Share (EPS).}
\usage{
trailingPEbasicEPS(currentShPr, basicEPS)
}
\arguments{
\item{currentShPr}{number.}

\item{basicEPS}{vector.}
}
\value{
Input values to two arguments  \code{currentShPr} and  \code{basicEPS}.
}
\description{
In the first edition of Security Analysis (by Graham and Dodd, 1934, as cited in Jerald E. Pinto, 2020), Benjamin Graham and David L. Dodd described common stock valuation based on PEs as the standard method of that era, and the PE is still the most familiar valuation measure today. Two chief variations of the PE: the trailing PE and the forward PE (also called the leading PE) are available. A trailing PE (sometimes referred to as a current PE) is its current market price divided by the most recent four quarters EPS. In such calculations, EPS is sometimes referred to as trailing 12 month (TTM) EPS.
Companies are themselves required to present both basic EPS and diluted EPS. Basic earnings per share data reflect total earnings divided by the weighted average number of shares actually outstanding during the period. (Jerald E. Pinto, 2020). In this method, trailing PE on basic Earnings Per Share (EPS) is being computed (Jerald E. Pinto, 2020).
}
\details{
According to information provided by Jerald E. Pinto (2020), the method \code{trailingPEbasicEPS} is developed for computing trailing Price to Earnings Multiple based on basic EPS for the values passed to its two arguments. Here, \code{currentShPr} is  current Share Price and \code{basicEPS} is basic EPS as defined in the description above.
}
\examples{
trailingPEbasicEPS(currentShPr=596.5,basicEPS=15.1)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
