# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Lagged Differences (Alternate Implementation)
#'
#' Calculates differences between subsequent (or lagged) elements of a vector. 
#' Very similar to \code{\link[base]{diff}}, but written in C++.
#'
#' @param x Numeric vector.
#' @param lag Numeric value (e.g. 2 for differences between 1st and 3rd
#' element, 2nd and 4th, ...).
#'
#'
#' @return Numeric vector.
#'
#'
#' @examples
#' # Generate 1 million values from Poisson(3) distribution
#' x <- rpois(100000, 3)
#'
#' # Calculate vector of differences between subsequent values
#' y <- diffs(x)
#'
#' # Could get same result from base R function diff
#' z <- diff(x)
#' all.equal(y, z)
#'
#' # But diffs is faster
#' benchmark(diffs(x), diff(x), replications = 100)
#'
#'
#'@export
diffs <- function(x, lag = 1L) {
    .Call(`_stocks_diffs`, x, lag)
}

mdd_p <- function(x) {
    .Call(`_stocks_mdd_p`, x)
}

mdd_p_indices <- function(x) {
    .Call(`_stocks_mdd_p_indices`, x)
}

mdd_hl <- function(highs, lows) {
    .Call(`_stocks_mdd_hl`, highs, lows)
}

mdd_hl_indices <- function(highs, lows) {
    .Call(`_stocks_mdd_hl_indices`, highs, lows)
}

#' Lagged Proportion Changes
#'
#' Calculates proportion changes between subsequent (or lagged) elements of a 
#' vector.
#'
#' @param x Numeric vector.
#' @param lag Numeric value (e.g. 2 for differences between 1st and 3rd
#' element, 2nd and 4th, ...).
#'
#'
#' @return Numeric vector.
#'
#'
#' @examples
#' # Generate 10 values from N(0, 1)
#' x <- rnorm(10)
#' 
#' # Calculate vector of proportion changes between subsequent values
#' (y <- pchanges(x))
#' 
#' # Equivalent base R computation
#' len <- length(x)
#' p1 <- x[2: len] 
#' p2 <- x[1: (len - 1)] 
#' y2 <- p1 / p2 - 1
#' all.equal(y, y2)
#' 
#'
#'@export
pchanges <- function(x, lag = 1L) {
    .Call(`_stocks_pchanges`, x, lag)
}

#' Lagged Proportion Differences
#'
#' Calculates proportion differences between subsequent (or lagged) elements of 
#' a vector.
#'
#' @param x Numeric vector.
#' @param lag Numeric value (e.g. 2 for differences between 1st and 3rd
#' element, 2nd and 4th, ...).
#'
#'
#' @return Numeric vector.
#'
#'
#' @examples
#' # Generate 10 values from N(0, 1)
#' x <- rnorm(10)
#' 
#' # Calculate vector of proportion differences between subsequent values
#' (y <- pdiffs(x))
#' 
#' # Equivalent base R computation
#' len <- length(x) 
#' p1 <- x[2: len]
#' p2 <- x[1: (len - 1)]
#' y2 <- (p1 - p2) / (0.5 * (p1 + p2))
#' all.equal(y, y2)
#' 
#'
#'@export
pdiffs <- function(x, lag = 1L) {
    .Call(`_stocks_pdiffs`, x, lag)
}

#' Ratios of Subsequent Elements in a Vector
#' 
#' Calculates vector of ratios of a vector, i.e. ratio of \code{x[2]} to 
#' \code{x[1]}, ratio of \code{x[3]} to \code{x[2]}, and so forth.
#' 
#'
#' @param x Numeric vector.
#'
#'
#' @return Numeric vector.
#'
#'
#' @examples
#' # Generate 10 values from N(0, 1)
#' x <- rnorm(10)
#' 
#' # Calculate vector of ratios
#' (y <- ratios(x))
#' 
#' # Slower base R computation
#' len <- length(x)
#' y2 <- x[2: len] / x[1: (len - 1)]
#' all.equal(y, y2)
#' 
#'
#'@export
ratios <- function(x) {
    .Call(`_stocks_ratios`, x)
}

