% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadataSTOICH.R
\name{metadataSTOICH}
\alias{metadataSTOICH}
\title{Explore The STOICH Data}
\usage{
metadataSTOICH(dataTables, metadata = NA)
}
\arguments{
\item{dataTables}{The STOICH data tables loaded using loadSTOICH.}

\item{metadata}{A character describing what type of metadata is being requested. Possible options are:
"variables", "joined", "full".
metadata="joined" returns the variable names after joinSTOICH is performed (you can use this name before the join to identify a table and variable).
metadata="full" returns a table of all the variables, the table name it belongs to and what data is stored in each variable.}
}
\value{
A vector or table with the requested data.
}
\description{
Used to help explore the STOICH data.
}
\examples{
\dontrun{
# Load the data
stoichData <- loadSTOICH(dataPath="C:/Users/example_user/STOICH_data_location")

# list the variable names
metadataSTOICH(stoichData, "variables")

}

}
\author{
Chad Petersen \email{cpetersen4@unl.edu}
}
