% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.rule.tite.R
\name{calc.rule.tite}
\alias{calc.rule.tite}
\title{Stopping Rule Calculation (TITE method)}
\usage{
calc.rule.tite(n, p0, alpha, type, param = NULL, iter = 50)
}
\arguments{
\item{n}{Maximum sample size}

\item{p0}{The toxicity probability under the null hypothesis}

\item{alpha}{The desired type I error / false positive rate for the stopping rule}

\item{type}{The method used for constructing the TITE stopping rule. Choices include a Pocock test ("Pocock"), an O'Brien-Fleming test ("OBF"), a Wang-Tsiatis test ("WT"), the Bayesian beta-extended binomial method ("BB"), a truncated SPRT ("SPRT"), and a maximized SPRT ("MaxSPRT").}

\item{param}{A vector of the extra parameter(s) needed for certain stopping rule methods. For Wang-Tsiatis tests, this is the Delta parameter. For the Geller et al. method, this is the vector of hyperparameters (a,b) for the beta prior on the toxicity probability. For truncated SPRT, this is the targeted alternative toxicity probability p1.}

\item{iter}{The number of iterations used to search for the boundary}
}
\value{
A rule.tite object, which is a list with the following elements: Rule, a two-column matrix with the effective sample sizes and their corresponding rejection boundaries; \code{n}; \code{p0}; \code{alpha}; \code{type}; \code{param}; and cval, the boundary parameter for the rule
}
\description{
Calculate a stopping rule for safety monitoring of time-to-event data using the TITE approach.
}
\examples{
\dontrun{# Pocock test in 50 patient cohort at 10\% level, expected toxicity probability of 20\%
}
}
\references{
Geller, N.L., Follman, D., Leifer, E.S. and Carter, S.L. (2003). Design of early trials in stem cell transplantation: a hybrid frequentist-Bayesian approach. \emph{Advances in Clinical Trial Biostatistics}.

Goldman, A.I. (1987). Issues in designing sequential stopping rules for monitoring side effects in clinical trials. \emph{Controlled Clinical Trials}  \strong{8(4)}, 327-37.

Ivanova, A., Qaqish, B.F. and Schell, M.J. (2005). Continuous toxicity monitoring in phase II trials in oncology. \emph{Biometrics} \strong{61(2)}, 540-545.

Kulldorff, M., Davis, R.L., Kolczak, M., Lewis, E., Lieu, T. and Platt, R. (2011). A maximized sequential probability ratio test for drug and vaccine safety surveillance. \emph{Sequential Analysis} \strong{30(1)}, 58-78.

Martens, M.J. and Logan, B.R. (2024). Statistical Rules for Safety Monitoring in Clinical Trials. \emph{Clinical Trials} \strong{21(2)}, 152-161.

Wang, S.K. and Tsiatis, A.A. (1987). Approximately optimal one-parameter boundaries for group sequential trials. \emph{Biometrics} \strong{193-199}.
}
