% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srbeta.R
\name{srbeta_optimize}
\alias{srbeta_optimize}
\title{Optimizing Beta Distribution proposal}
\usage{
srbeta_optimize(
  shape1 = 2,
  shape2 = 2,
  xl = 0,
  xr = 1,
  steps = NULL,
  proposal_range = NULL,
  theta = 0.1,
  target_sample_size = 1000,
  verbose = FALSE
)
}
\arguments{
\item{shape1}{(optional) Numeric. The first shape parameter (\eqn{\alpha}) of the Beta distribution. Defaults to \code{1}.}

\item{shape2}{(optional) Numeric. The second shape parameter (\eqn{\beta}) of the Beta distribution. Defaults to \code{1}.}

\item{xl}{Numeric. Left truncation bound for the target distribution. Defaults to \code{0}, as the Beta distribution is defined only on the interval \code{[0, 1]}.}

\item{xr}{Numeric. Right truncation bound for the target distribution. Defaults to \code{1}, as the Beta distribution is defined only on the interval \code{[0, 1]}.}

\item{steps}{(optional) Integer. Desired number of steps in the proposal. Defaults to \code{4091}.}

\item{proposal_range}{(optional) Numeric vector. Specifies the range for optimizing the steps part of the proposal. Defaults to \code{NULL}, indicating automatic range selection.}

\item{theta}{Numeric. A parameter for proposal optimization. Defaults to 0.1.}

\item{target_sample_size}{(optional) Integer. Target sample size for proposal optimization. Defaults to \code{1000}.}

\item{verbose}{Boolean. If \code{TRUE}, detailed optimization information, including areas and steps, will be displayed. Defaults to \code{FALSE}.}
}
\value{
A list containing the optimized proposal and related parameters for the specified Beta distribution. The proposal is also cached for internal use.
\describe{
\item{\code{data}}{Detailed information about the proposal steps, including \code{x}, \code{s_upper}, \code{p_a}, and \code{s_upper_lower}.}
\item{\code{areas}}{The areas under the left tail, steps, and right tail of the proposal distribution.}
\item{\code{steps_number}}{The number of steps in the proposal.}
\item{\code{f_params}}{The parameters (\code{shape1} and \code{shape2}) of the Beta distribution.}
}
}
\description{
The \code{srbeta_optimize()} function generates an optimized proposal for a targeted Beta distribution.
The proposal can be customized and adjusted based on various options provided by the user.
}
\details{
When \code{srbeta_optimize()} is explicitly called:
\itemize{
\item A proposal is created and cached. If no parameters are provided, a standard proposal is created with \code{shape1 = 1} and \code{shape2 = 1}.
\item Providing \code{shape1} and \code{shape2} creates a custom proposal, which is cached for use with \code{srbeta_custom()}.
\item The optimization process can be controlled via parameters such as \code{steps}, \code{proposal_range}, or
\code{theta}. If no parameters are provided, the proposal is optimized via brute force based on the
\code{target_sample_size}.
}
}
\examples{
# Generate a standard proposal with shape1 = 1 and shape2 = 1
standard_proposal <- srbeta_optimize()

# Generate a custom proposal with shape1 = 2 and shape2 = 3
custom_proposal <- srbeta_optimize(shape1 = 2, shape2 = 3)

}
\seealso{
\code{\link{srbeta_custom}}: Function to sample from a custom proposal generated by \code{srbeta_optimize()}.
}
