% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{a2lm}
\alias{a2lm}
\title{(3D) Array to List of Matrices}
\usage{
a2lm(a, along = 3L, check = TRUE)
}
\arguments{
\item{a}{3D array.}

\item{along}{integer vector of length 1 specifying the dimension to slice the array
along. This dimension is converted to the list dimension. 1 = rows; 2 = columns;
3 = layers.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{a} is a 3D array.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
list of matrices - all with the same dimensions.
}
\description{
\code{a2lm} converts a (3D) array to a list of matrices. This is a simple call
to \code{asplit} with a default to convert the third dimension to a list dimension.
}
\examples{
a2lm(HairEyeColor)
a2lm(HairEyeColor, along = 1)
try_expr(a2lm(mtcars)) # error b/c  not a 3D array
}
