% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{language}
\alias{language}
\title{language}
\usage{
language(
  lang = getOption("stranslate.lang"),
  available.languages = NULL,
  .domain = NULL
)
}
\arguments{
\item{lang}{character: a language code, e.g. from ISO-639}

\item{available.languages}{character: names of languages (default: \code{NULL}). If \code{NULL} then list of loaded languages is used.}

\item{.domain}{character: domain names (default: \code{NULL})}
}
\value{
character of languages use to find a message
}
\description{
Returns which loaded language will be used for finding a message depending on \code{.domain}.
}
\examples{
print(options("stranslate.lang"))   # current default language
language("de_AT", c("de", "de_IT")) # request austrian german
#
loadMsg(system.file("messages", "messages.txt", package = "stranslate"))
language("de_AT")                   # request austrian german
language("tlh")                     # request klingon, not available -> "en"
}
