% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMCtest.R
\name{SMCtest}
\alias{SMCtest}
\title{This function performs stratified Max-Combo test.}
\usage{
SMCtest(
  time,
  event,
  group,
  stratum,
  alternative = c("two.sided", "less", "greater"),
  rho = c(0, 1, 1, 0),
  gamma = c(0, 0, 1, 1)
)
}
\arguments{
\item{time}{a vector of event or censored times.}

\item{event}{a vector with entries 0 or 1, indicating event occurrence (1) or time being censored (0).}

\item{group}{a vector indicating treatment groups.}

\item{stratum}{a vector of stratification factor.}

\item{alternative}{choose from \code{"two.sided"}, \code{"less"} or \code{"greater"} to determine which type of tests to conduct and calculate the corresponding p-values.}

\item{rho}{a vector indicating different values of rho in Fleming-Harrington weight.}

\item{gamma}{a vector indicating different values of gamma in Fleming-Harrington weight.}
}
\value{
A list with components:
\item{z.list}{a vector of z values calculated from all startified weighted log-rank tests under stratification method 1.}
\item{z.max}{the z value that is the furthest away from 0 under stratification method 1.}
\item{cov}{the covariance matrix of different startified weighted log-rank tests under stratification method 1.}
\item{pval}{p-value of desired alternative test under stratification method 1.}
\item{z.list2}{a vector of z values calculated from all startified weighted log-rank tests under stratification method 2.}
\item{z.max2}{the z value that is the furthest away from 0 under stratification method 2.}
\item{cov2}{the covariance matrix of different startified weighted log-rank tests under stratification method 2.}
\item{pval2}{p-value of desired alternative test under stratification method 2.}
\item{z.list3}{a vector of z values calculated from all startified weighted log-rank tests under stratification method 3.}
\item{z.max3}{the z value that is the furthest away from 0 under stratification method 3.}
\item{cov3}{the covariance matrix of different startified weighted log-rank tests under stratification method 3.}
\item{pval3}{p-value of desired alternative test under stratification method 3.}
}
\description{
This function performs stratified Max-Combo test.
}
\examples{
data(sim_data)
##load survival data
time <- sim_data$event_time
event <- sim_data$event_status
group <- sim_data$group
stratum <- sim_data$strata

##perform stratified max-combo test
SMCtest(time,event,group,stratum,alternative="two.sided",rho=c(0,1,1,0),gamma=c(0,0,1,1))

}
\references{
Magirr, D. and Jiménez, J. (2023).
Stratified modestly-weighted log-rank tests in settings with an anticipated delayed separation of survival curves.
{\emph{Biometrical Journal.}, 2023;65:2200126} \doi{10.1002/bimj.202200126}
}
\seealso{
\code{\link{WLRtest}}
}
