/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.trees.HoeffdingTree;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.tasks.TaskMonitor;

public class AccuracyUpdatedEnsemble
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Classifier to train.", Classifier.class, "trees.HoeffdingTree -e 2000000 -g 100 -c 0.01");
    public IntOption memberCountOption = new IntOption("memberCount", 'n', "The maximum number of classifiers in an ensemble.", 10, 1, Integer.MAX_VALUE);
    public IntOption chunkSizeOption = new IntOption("chunkSize", 'c', "The chunk size used for classifier creation and evaluation.", 500, 1, Integer.MAX_VALUE);
    public IntOption maxByteSizeOption = new IntOption("maxByteSize", 'm', "Maximum memory consumed by ensemble.", 0x2000000, 0, Integer.MAX_VALUE);
    protected double[][] weights;
    protected long[] classDistributions;
    protected Classifier[] learners;
    protected int processedInstances;
    protected Classifier candidate;
    protected Instances currentChunk;

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.candidate = (Classifier)this.getPreparedClassOption(this.learnerOption);
        this.candidate.resetLearning();
        super.prepareForUseImpl(monitor, repository);
    }

    @Override
    public void resetLearningImpl() {
        this.currentChunk = null;
        this.classDistributions = null;
        this.processedInstances = 0;
        this.learners = new Classifier[0];
        this.candidate = (Classifier)this.getPreparedClassOption(this.learnerOption);
        this.candidate.resetLearning();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.initVariables();
        int n = (int)inst.classValue();
        this.classDistributions[n] = this.classDistributions[n] + 1L;
        this.currentChunk.add(inst);
        ++this.processedInstances;
        if (this.processedInstances % this.chunkSizeOption.getValue() == 0) {
            this.processChunk();
        }
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        DoubleVector combinedVote = new DoubleVector();
        if (this.trainingWeightSeenByModel > 0.0) {
            for (int i = 0; i < this.learners.length; ++i) {
                DoubleVector vote;
                if (!(this.weights[i][0] > 0.0) || !((vote = new DoubleVector(this.learners[(int)this.weights[i][1]].getVotesForInstance(inst))).sumOfValues() > 0.0)) continue;
                vote.normalize();
                vote.scaleValues(this.weights[i][0] / (1.0 * (double)this.learners.length + 1.0));
                combinedVote.addValues(vote);
            }
        }
        return combinedVote.getArrayRef();
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public Classifier[] getSubClassifiers() {
        return (Classifier[])this.learners.clone();
    }

    protected void processChunk() {
        int i;
        Classifier addedClassifier = null;
        double mse_r = this.computeMseR();
        double candidateClassifierWeight = 1.0 / (mse_r + Double.MIN_VALUE);
        for (i = 0; i < this.learners.length; ++i) {
            this.weights[i][0] = 1.0 / (mse_r + this.computeMse(this.learners[(int)this.weights[i][1]], this.currentChunk) + Double.MIN_VALUE);
        }
        if (this.learners.length < this.memberCountOption.getValue()) {
            addedClassifier = this.addToStored(this.candidate, candidateClassifierWeight);
        } else {
            int poorestClassifier = this.getPoorestClassifierIndex();
            if (this.weights[poorestClassifier][0] < candidateClassifierWeight) {
                this.weights[poorestClassifier][0] = candidateClassifierWeight;
                this.learners[(int)this.weights[poorestClassifier][1]] = addedClassifier = this.candidate.copy();
            }
        }
        for (i = 0; i < this.learners.length; ++i) {
            this.trainOnChunk(this.learners[(int)this.weights[i][1]]);
        }
        this.classDistributions = null;
        this.currentChunk = null;
        this.candidate = (Classifier)this.getPreparedClassOption(this.learnerOption);
        this.candidate.resetLearning();
        this.enforceMemoryLimit();
    }

    protected void enforceMemoryLimit() {
        double memoryLimit = (double)this.maxByteSizeOption.getValue() / (double)(this.learners.length + 1);
        for (int i = 0; i < this.learners.length; ++i) {
            ((HoeffdingTree)this.learners[(int)this.weights[i][1]]).maxByteSizeOption.setValue((int)Math.round(memoryLimit));
            ((HoeffdingTree)this.learners[(int)this.weights[i][1]]).enforceTrackerLimit();
        }
    }

    protected double computeMseR() {
        double mse_r = 0.0;
        for (int i = 0; i < this.classDistributions.length; ++i) {
            double p_c = (double)this.classDistributions[i] / (double)this.chunkSizeOption.getValue();
            mse_r += p_c * ((1.0 - p_c) * (1.0 - p_c));
        }
        return mse_r;
    }

    protected double computeMse(Classifier learner, Instances chunk) {
        double mse_i = 0.0;
        for (int i = 0; i < chunk.numInstances(); ++i) {
            try {
                double voteSum = 0.0;
                for (double element : learner.getVotesForInstance(chunk.instance(i))) {
                    voteSum += element;
                }
                if (voteSum > 0.0) {
                    double f_ci = learner.getVotesForInstance(chunk.instance(i))[(int)chunk.instance(i).classValue()] / voteSum;
                    mse_i += (1.0 - f_ci) * (1.0 - f_ci);
                    continue;
                }
                mse_i += 1.0;
                continue;
            }
            catch (Exception e) {
                mse_i += 1.0;
            }
        }
        return mse_i /= (double)this.chunkSizeOption.getValue();
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        Measurement[] measurements = new Measurement[this.memberCountOption.getValue()];
        for (int m = 0; m < this.memberCountOption.getValue(); ++m) {
            measurements[m] = new Measurement("Member weight " + (m + 1), -1.0);
        }
        if (this.weights != null) {
            for (int i = 0; i < this.weights.length; ++i) {
                measurements[i] = new Measurement("Member weight " + (i + 1), this.weights[i][0]);
            }
        }
        return measurements;
    }

    protected Classifier addToStored(Classifier newClassifier, double newClassifiersWeight) {
        Classifier addedClassifier = null;
        Classifier[] newStored = new Classifier[this.learners.length + 1];
        double[][] newStoredWeights = new double[newStored.length][2];
        for (int i = 0; i < newStored.length; ++i) {
            if (i < this.learners.length) {
                newStored[i] = this.learners[i];
                newStoredWeights[i][0] = this.weights[i][0];
                newStoredWeights[i][1] = this.weights[i][1];
                continue;
            }
            newStored[i] = addedClassifier = newClassifier.copy();
            newStoredWeights[i][0] = newClassifiersWeight;
            newStoredWeights[i][1] = i;
        }
        this.learners = newStored;
        this.weights = newStoredWeights;
        return addedClassifier;
    }

    private int getPoorestClassifierIndex() {
        int minIndex = 0;
        for (int i = 1; i < this.weights.length; ++i) {
            if (!(this.weights[i][0] < this.weights[minIndex][0])) continue;
            minIndex = i;
        }
        return minIndex;
    }

    private void initVariables() {
        if (this.currentChunk == null) {
            this.currentChunk = new Instances(this.getModelContext());
        }
        if (this.classDistributions == null) {
            this.classDistributions = new long[this.getModelContext().classAttribute().numValues()];
            for (int i = 0; i < this.classDistributions.length; ++i) {
                this.classDistributions[i] = 0L;
            }
        }
    }

    private void trainOnChunk(Classifier classifierToTrain) {
        for (int num = 0; num < this.chunkSizeOption.getValue(); ++num) {
            classifierToTrain.trainOnInstance(this.currentChunk.instance(num));
        }
    }
}

