% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_gaps.R
\name{find_gaps}
\alias{find_gaps}
\title{Identify gaps in a sequence of dates}
\usage{
find_gaps(dates)
}
\arguments{
\item{dates}{A vector of dates to be evaluated. Must be 'Date' class.}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
n_days \tab integer \tab The number of days in the gap \cr
start \tab date \tab The start date of the gap \cr
end \tab date \tab The end date of the gap \cr
location \tab integer \tab The location index of the gap in the original dates vector
}
}
\description{
Identify gaps in a sequence of dates and return a data frame with the number of missing days,
start and end dates, and the starting location of the gap in the vector. Intended to be used on
a (near) daily water quality record.
}
\examples{
dates <- as.Date(c("2020-01-01", "2020-01-03", "2020-01-04", "2020-01-10", "2020-01-15"))
find_gaps(dates)

dates_no_gaps <- seq.Date(as.Date("2020-01-01"), as.Date("2020-01-05"), by = "day")
find_gaps(dates_no_gaps)

dates_with_na <- as.Date(c("2020-01-01", "2020-01-03", NA, "2020-01-10"))
find_gaps(dates_with_na)
}
