% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_cluster.R
\name{cv_cluster}
\alias{cv_cluster}
\title{Spatial Cluster-Based Partitions for Cross-Validation}
\usage{
cv_cluster(features, k, k_mult = 5, ...)
}
\arguments{
\item{features}{A scaled matrix of features to be used in the clustering.
Scaling usually done with \link[base]{scale} and should not include the
predictor variable.}

\item{k}{The number of partitions for k-fold cross-validation.}

\item{k_mult}{k*k_mult determines the number of subgroups that will be
created as part of the balancing algorithm.}

\item{...}{Additional arguments passed to \link[stats]{kmeans} as needed.}
}
\value{
An integer vector that is number of rows of features with indices of
 each group.
}
\description{
This function creates cluster-based partitions of a sample space based on
  k-means clustering. Included in the function are algorithms that attempt
  to produce clusters of roughly equal size.
}
\details{
More information regarding spatial cross-validation can be found in
 Robin Lovelace's explanation of spatial
 cross-validation in his
 \href{https://r.geocompx.org/spatial-cv.html?q=cross\%20validation#intro-cv}{textbook}.
}
\examples{
 # Creating a matrix of predictor variables
 x_data <- base::scale(data_gen_lm(30)[, -1])
 groups <- cv_cluster(x_data, 5, k_mult = 5)
 groups
}
