% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_data_prob.R
\name{split_data_prob}
\alias{split_data_prob}
\title{Create Train Index Set}
\usage{
split_data_prob(data, test_prop)
}
\arguments{
\item{data}{A data.frame object used to determine the length of the vector.}

\item{test_prop}{A numeric that is between zero and one that represents the
proportion of observations to be included in the test data.}
}
\value{
A logical vector is returned that is the same length as the number of
  rows of the data.
}
\description{
This function takes in a data.frame object and the training size and returns
  a logical vector indicating which entries to include.
}
\examples{
  lm_data <- data_gen_lm(10)
  indices <- split_data_prob(lm_data, .8)
  train <- lm_data[indices, ]
  test <- lm_data[!indices, ]
}
