% Generated by roxygen2 (4.0.1): do not edit by hand
\name{stressLineChart}
\alias{stressLineChart}
\title{Financial stress component data as an unstacked line chart.}
\usage{
stressLineChart(e, range = NA)
}
\arguments{
\item{e}{an object of class \code{stress} as returned by \code{\link[stressr]{getStressComponents}} and its many offspring.}

\item{range}{a range string as used by \code{xts} to subset time series dates, e.g. "1996/1997".  Defaults to NA for full range.}
}
\description{
Provides a convenience function for passing a \code{stress} object to \code{xyplot}.
}
\details{
Provides several assumptions about the display of the \code{stress} data to correspond to similar presentations at the Cleveland Fed's data site.
}
\examples{
\dontrun{
es <- getEqityStress()
stressLineChart(es,"2007/2009)
}
}
\seealso{
xyplot.stress stressAreaChart getStressComponents getComponentSummary getEquityMarkets getFundingMarkets getCreditMarkets getForeignExchangeMarkets getRealEstateMarkets getSecuritizationMarkets
}

