% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding_detection.R
\name{stri_enc_isascii}
\alias{stri_enc_isascii}
\title{Check If a Data Stream Is Possibly in ASCII}
\usage{
stri_enc_isascii(str)
}
\arguments{
\item{str}{character vector, a raw vector, or
a list of \code{raw} vectors}
}
\value{
Returns a logical vector.
The i-th element indicates whether the i-th string
corresponds to a valid ASCII byte sequence.
}
\description{
The function checks whether all bytes in a string are <= 127.
}
\details{
This function is independent of the way \R marks encodings in
character strings (see \link{Encoding} and \link{stringi-encoding}).
}
\examples{
stri_enc_isascii(letters[1:3])
stri_enc_isascii('\u0105\u0104')

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other encoding_detection: 
\code{\link{about_encoding}},
\code{\link{stri_enc_detect}()},
\code{\link{stri_enc_detect2}()},
\code{\link{stri_enc_isutf16be}()},
\code{\link{stri_enc_isutf8}()}
}
\concept{encoding_detection}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
